package Daje::Database::Migrator;
use Mojo::Base -base, -signatures;
use v5.40;

use Mojo::Loader qw(load_class);

# NAME
# ====
#
# Daje::Database::Migrator - It's the database migrate plugin for Daje::Workflow
#
# SYNOPSIS
# ========
#
#    use Daje::Database::Migrator;
#
#    push @{$migrations}, {class => 'Daje::Workflow::Database', name => 'workflow', migration => 2};
#
#    push @{$migrations}, {file => '/home/user/schema/users.sql', name => 'users'};
#
#    Daje::Database::Migrator->new(
#         pg            => $pg,
#         migrations    => $migrations,
#     )->migrate();
#
# DESCRIPTION
# ===========
#
# Daje::Database::Migrator is the Database migrate plugin for Daje
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

our $VERSION = "0.01";

has 'pg';
has 'migrations';

sub migrate($self) {

    my $length = scalar @{$self->migrations};
    for (my $i = 0; $i < $length; $i++) {
        if (exists @{$self->migrations}[$i]->{class}) {
            my $cl = load_class @{$self->migrations}[$i]->{class};
            $self->pg->migrations->name(
                @{$self->migrations}[$i]->{name}
            )->from_data(
                @{$self->migrations}[$i]->{class},
                @{$self->migrations}[$i]->{name}
            )->migrate(
                @{$self->migrations}[$i]->{migration}
            );
        } elsif (exists @{$self->migrations}[$i]->{file}) {
            $self->pg->migrations->name(
                @{$self->migrations}[$i]->{name}
            )->from_file(
                @{$self->migrations}[$i]->{file}
            )->migrate(
                @{$self->migrations}[$i]->{migration}
            );
        }
    }

    return 1;
}


1;
__END__




#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Database::Migrator - It's the database migrate plugin for Daje::Workflow



=head1 SYNOPSIS


   use Daje::Database::Migrator;

   push @{$migrations}, {class => 'Daje::Workflow::Database', name => 'workflow', migration => 2};

   push @{$migrations}, {file => '/home/user/schema/users.sql', name => 'users'};

   Daje::Database::Migrator->new(
        pg            => $pg,
        migrations    => $migrations,
    )->migrate();



=head1 DESCRIPTION


Daje::Database::Migrator is the Database migrate plugin for Daje



=head1 REQUIRES

L<Mojo::Loader> 

L<v5.40> 

L<Mojo::Base> 


=head1 METHODS

=head2 migrate($self)

 migrate($self)();


=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

