/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import thredds.catalog.InvAccess;
import thredds.catalog.InvDataset;
import thredds.catalog.ServiceType;
import ucar.nc2.constants.FeatureType;

public abstract class DatasetFilter {
    public abstract int accept(InvDataset var1);

    public static class ByDataType
    extends DatasetFilter {
        private FeatureType type;

        public ByDataType(FeatureType type) {
            this.type = type;
        }

        public int accept(InvDataset d) {
            if (null == d.getDataType()) {
                return 0;
            }
            return d.getDataType() == this.type ? 1 : -1;
        }
    }

    public static class ByServiceType
    extends DatasetFilter {
        private ServiceType type;

        public ByServiceType(ServiceType type) {
            this.type = type;
        }

        public int accept(InvDataset d) {
            for (InvAccess a : d.getAccess()) {
                if (a.getService().getServiceType() != this.type) continue;
                return 1;
            }
            for (InvAccess a : d.getAccess()) {
                if (a.getService().getServiceType() == ServiceType.QC) {
                    return 0;
                }
                if (a.getService().getServiceType() != ServiceType.RESOLVER) continue;
                return 0;
            }
            return -1;
        }
    }
}

