/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging;

import com.drew.imaging.ImageProcessingException;
import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.psd.PsdMetadataReader;
import com.drew.imaging.tiff.TiffMetadataReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifThumbnailDirectory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class ImageMetadataReader {
    private static final int JPEG_FILE_MAGIC_NUMBER = 65496;
    private static final int MOTOROLA_TIFF_MAGIC_NUMBER = 19789;
    private static final int INTEL_TIFF_MAGIC_NUMBER = 18761;
    private static final int PSD_MAGIC_NUMBER = 14402;

    @NotNull
    public static Metadata readMetadata(@NotNull BufferedInputStream inputStream, boolean waitForBytes) throws ImageProcessingException, IOException {
        int magicNumber = ImageMetadataReader.readMagicNumber(inputStream);
        return ImageMetadataReader.readMetadata(inputStream, null, magicNumber, waitForBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Metadata readMetadata(@NotNull File file) throws ImageProcessingException, IOException {
        int magicNumber;
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            magicNumber = ImageMetadataReader.readMagicNumber(inputStream);
        }
        finally {
            inputStream.close();
        }
        return ImageMetadataReader.readMetadata(null, file, magicNumber, false);
    }

    @NotNull
    private static Metadata readMetadata(@Nullable BufferedInputStream inputStream, @Nullable File file, int magicNumber, boolean waitForBytes) throws ImageProcessingException, IOException {
        assert (file != null ^ inputStream != null);
        if ((magicNumber & 0xFFD8) == 65496) {
            if (inputStream != null) {
                return JpegMetadataReader.readMetadata(inputStream, waitForBytes);
            }
            return JpegMetadataReader.readMetadata(file);
        }
        if (magicNumber == 18761 || magicNumber == 19789) {
            if (inputStream != null) {
                return TiffMetadataReader.readMetadata(inputStream, waitForBytes);
            }
            return TiffMetadataReader.readMetadata(file);
        }
        if (magicNumber == 14402) {
            if (inputStream != null) {
                return PsdMetadataReader.readMetadata(inputStream, waitForBytes);
            }
            return PsdMetadataReader.readMetadata(file);
        }
        throw new ImageProcessingException("File format is not supported");
    }

    private static int readMagicNumber(@NotNull BufferedInputStream inputStream) throws IOException {
        inputStream.mark(2);
        int magicNumber = inputStream.read() << 8 | inputStream.read();
        inputStream.reset();
        return magicNumber;
    }

    private ImageMetadataReader() throws Exception {
        throw new Exception("Not intended for instantiation");
    }

    public static void main(@NotNull String[] args) throws MetadataException, IOException {
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        boolean thumbRequested = argList.remove("/thumb");
        boolean wikiFormat = argList.remove("/wiki");
        if (argList.size() < 1) {
            System.out.println("Usage: java -jar metadata-extractor-a.b.c.jar <filename> [<filename>] [/thumb] [/wiki]");
            System.exit(1);
        }
        for (String filePath : argList) {
            long startTime = System.nanoTime();
            File file = new File(filePath);
            if (!wikiFormat && argList.size() > 1) {
                System.out.println("***** PROCESSING: " + filePath);
            }
            Metadata metadata = null;
            try {
                metadata = ImageMetadataReader.readMetadata(file);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                System.exit(1);
            }
            long took = System.nanoTime() - startTime;
            if (!wikiFormat) {
                System.out.println("Processed " + (double)file.length() / 1048576.0 + "MB file in " + (double)took / 1000000.0 + "ms");
            }
            if (wikiFormat) {
                String fileName = file.getName();
                String urlName = fileName.replace(" ", "%20");
                ExifIFD0Directory exifIFD0Directory = metadata.getOrCreateDirectory(ExifIFD0Directory.class);
                String make = ImageMetadataReader.escapeForWiki(exifIFD0Directory.getString(271));
                String model = ImageMetadataReader.escapeForWiki(exifIFD0Directory.getString(272));
                System.out.println();
                System.out.println("-----");
                System.out.println();
                System.out.printf("= %s - %s =%n", make, model);
                System.out.println();
                System.out.printf("<a href=\"http://metadata-extractor.googlecode.com/svn/sample-images/%s\">%n", urlName);
                System.out.printf("<img src=\"http://metadata-extractor.googlecode.com/svn/sample-images/%s\" width=\"300\"/><br/>%n", urlName);
                System.out.println(fileName);
                System.out.println("</a>");
                System.out.println();
                System.out.println("|| *Directory* || *Tag Id* || *Tag Name* || *Tag Description* ||");
            }
            for (Directory directory : metadata.getDirectories()) {
                for (Tag tag : directory.getTags()) {
                    String tagName = tag.getTagName();
                    String directoryName = directory.getName();
                    String description = tag.getDescription();
                    if (wikiFormat) {
                        System.out.printf("||%s||0x%s||%s||%s||%n", ImageMetadataReader.escapeForWiki(directoryName), Integer.toHexString(tag.getTagType()), ImageMetadataReader.escapeForWiki(tagName), ImageMetadataReader.escapeForWiki(description));
                        continue;
                    }
                    System.out.printf("[%s] %s = %s%n", directoryName, tagName, description);
                }
                for (String error : directory.getErrors()) {
                    System.err.println("ERROR: " + error);
                }
            }
            if (args.length <= 1 || !thumbRequested) continue;
            ExifThumbnailDirectory directory = metadata.getDirectory(ExifThumbnailDirectory.class);
            if (directory != null && directory.hasThumbnailData()) {
                System.out.println("Writing thumbnail...");
                directory.writeThumbnail(args[0].trim() + ".thumb.jpg");
                continue;
            }
            System.out.println("No thumbnail data exists in this image");
        }
    }

    @Nullable
    private static String escapeForWiki(@Nullable String text) {
        if (text == null) {
            return null;
        }
        if ((text = text.replaceAll("(\\W|^)(([A-Z][a-z0-9]+){2,})", "$1!$2")) != null && text.length() > 120) {
            text = text.substring(0, 120) + "...";
        }
        if (text != null) {
            text = text.replace("[", "`[`").replace("]", "`]`").replace("<", "`<`").replace(">", "`>`");
        }
        return text;
    }
}

