package SLUB::LZA::Rosetta::TA::SOAP;
use strict;
use warnings;

# VERSION

# ABSTRACT: module to handle SOAP requests for ta-tool

sub get_ie_pid_by_sip {
    my $sip = shift;
    my $host = $SLUB::LZA::Rosetta::TA::config{host};
    my $protocol = "https";
    my $port = 8443;
    if (defined $SLUB::LZA::Rosetta::TA::Command::config{httponly}) {
        $protocol = 'http';
        $port = 1801;
    }
    my $wsdl_url="${protocol}://${host}:${port}/dpsws/repository/SipWebServices?wsdl";
    #print "DEBUG: $wsdl_url";
    my $soap = SOAP::Lite->new;
    $soap->proxy(
        $wsdl_url,
        timeout    => 3000,
        keep_alive => 1,
        ssl_opts   => {
            verify_hostname=>1,
            # SSL_ca_path => '/etc/ssl/',
        }
    );
    $soap->ns('http://dps.exlibris.com/');
    $soap->on_action(sub {return ''}); # remove SOAP action if used with Rosetta 6.xx or higher
    my $som = $soap->call(
        'getSipIEs',
        SOAP::Data->name('arg0')->value($sip)->type('string')
    );
    if ($som->fault) {
        confess ("ERROR: server '$host' says: ".$som->faultstring."\n");
    }
    #my $res = log_empty_result( $som, $logger, $host);
    my $res = $som->result;
    if ($res eq '') { # defined but empty result without SOAP fault
        # HINT: 2 possibilities
        # * SIP-ID doesn't exist
        # * SIP-ID existed before but Rosetta clean up job removed all status infos
        return; # let caller decide how to act on an empty result (no SOAP error)
    }
    my $ie = $res;
    $ie=~s/^IE(\d*).*/$1/;
    return $ie;
}
1;
