# Generated by default/object.tt
package Paws::Honeycode::UpsertRowData;
  use Moose;
  has BatchItemId => (is => 'ro', isa => 'Str', request_name => 'batchItemId', traits => ['NameInRequest'], required => 1);
  has CellsToUpdate => (is => 'ro', isa => 'Paws::Honeycode::RowDataInput', request_name => 'cellsToUpdate', traits => ['NameInRequest'], required => 1);
  has Filter => (is => 'ro', isa => 'Paws::Honeycode::Filter', request_name => 'filter', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Honeycode::UpsertRowData

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Honeycode::UpsertRowData object:

  $service_obj->Method(Att1 => { BatchItemId => $value, ..., Filter => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Honeycode::UpsertRowData object:

  $result = $service_obj->Method(...);
  $result->Att1->BatchItemId

=head1 DESCRIPTION

Data needed to upsert rows in a table as part of a single item in the
BatchUpsertTableRows request.

=head1 ATTRIBUTES


=head2 B<REQUIRED> BatchItemId => Str

An external identifier that represents a single item in the request
that is being upserted as part of the BatchUpsertTableRows request.
This can be any string that you can use to identify the item in the
request. The BatchUpsertTableRows API puts the batch item id in the
results to allow you to link data in the request to data in the
results.


=head2 B<REQUIRED> CellsToUpdate => L<Paws::Honeycode::RowDataInput>

A map representing the cells to update for the matching rows or an
appended row. The key is the column id of the cell and the value is the
CellInput object that represents the data to set in that cell.


=head2 B<REQUIRED> Filter => L<Paws::Honeycode::Filter>

The filter formula to use to find existing matching rows to update. The
formula needs to return zero or more rows. If the formula returns 0
rows, then a new row will be appended in the target table. If the
formula returns one or more rows, then the returned rows will be
updated.

Note that the filter formula needs to return rows from the target table
for the upsert operation to succeed. If the filter formula has a syntax
error or it doesn't evaluate to zero or more rows in the target table
for any one item in the input list, then the entire
BatchUpsertTableRows request fails and no updates are made to the
table.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Honeycode>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

