# Generated by default/object.tt
package Paws::MediaConvert::Vp8Settings;
  use Moose;
  has Bitrate => (is => 'ro', isa => 'Int', request_name => 'bitrate', traits => ['NameInRequest']);
  has FramerateControl => (is => 'ro', isa => 'Str', request_name => 'framerateControl', traits => ['NameInRequest']);
  has FramerateConversionAlgorithm => (is => 'ro', isa => 'Str', request_name => 'framerateConversionAlgorithm', traits => ['NameInRequest']);
  has FramerateDenominator => (is => 'ro', isa => 'Int', request_name => 'framerateDenominator', traits => ['NameInRequest']);
  has FramerateNumerator => (is => 'ro', isa => 'Int', request_name => 'framerateNumerator', traits => ['NameInRequest']);
  has GopSize => (is => 'ro', isa => 'Num', request_name => 'gopSize', traits => ['NameInRequest']);
  has HrdBufferSize => (is => 'ro', isa => 'Int', request_name => 'hrdBufferSize', traits => ['NameInRequest']);
  has MaxBitrate => (is => 'ro', isa => 'Int', request_name => 'maxBitrate', traits => ['NameInRequest']);
  has ParControl => (is => 'ro', isa => 'Str', request_name => 'parControl', traits => ['NameInRequest']);
  has ParDenominator => (is => 'ro', isa => 'Int', request_name => 'parDenominator', traits => ['NameInRequest']);
  has ParNumerator => (is => 'ro', isa => 'Int', request_name => 'parNumerator', traits => ['NameInRequest']);
  has QualityTuningLevel => (is => 'ro', isa => 'Str', request_name => 'qualityTuningLevel', traits => ['NameInRequest']);
  has RateControlMode => (is => 'ro', isa => 'Str', request_name => 'rateControlMode', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaConvert::Vp8Settings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaConvert::Vp8Settings object:

  $service_obj->Method(Att1 => { Bitrate => $value, ..., RateControlMode => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaConvert::Vp8Settings object:

  $result = $service_obj->Method(...);
  $result->Att1->Bitrate

=head1 DESCRIPTION

Required when you set (Codec) under
(VideoDescription)E<gt>(CodecSettings) to the value VP8.

=head1 ATTRIBUTES


=head2 Bitrate => Int

Target bitrate in bits/second. For example, enter five megabits per
second as 5000000.


=head2 FramerateControl => Str

If you are using the console, use the Framerate setting to specify the
frame rate for this output. If you want to keep the same frame rate as
the input video, choose Follow source. If you want to do frame rate
conversion, choose a frame rate from the dropdown list or choose
Custom. The framerates shown in the dropdown list are decimal
approximations of fractions. If you choose Custom, specify your frame
rate as a fraction. If you are creating your transcoding job
specification as a JSON file without the console, use FramerateControl
to specify which value the service uses for the frame rate for this
output. Choose INITIALIZE_FROM_SOURCE if you want the service to use
the frame rate from the input. Choose SPECIFIED if you want the service
to use the frame rate you specify in the settings FramerateNumerator
and FramerateDenominator.


=head2 FramerateConversionAlgorithm => Str

Choose the method that you want MediaConvert to use when increasing or
decreasing the frame rate. We recommend using drop duplicate
(DUPLICATE_DROP) for numerically simple conversions, such as 60 fps to
30 fps. For numerically complex conversions, you can use interpolate
(INTERPOLATE) to avoid stutter. This results in a smooth picture, but
might introduce undesirable video artifacts. For complex frame rate
conversions, especially if your source video has already been converted
from its original cadence, use FrameFormer (FRAMEFORMER) to do
motion-compensated interpolation. FrameFormer chooses the best
conversion method frame by frame. Note that using FrameFormer increases
the transcoding time and incurs a significant add-on cost.


=head2 FramerateDenominator => Int

When you use the API for transcode jobs that use frame rate conversion,
specify the frame rate as a fraction. For example, 24000 / 1001 =
23.976 fps. Use FramerateDenominator to specify the denominator of this
fraction. In this example, use 1001 for the value of
FramerateDenominator. When you use the console for transcode jobs that
use frame rate conversion, provide the value as a decimal number for
Framerate. In this example, specify 23.976.


=head2 FramerateNumerator => Int

When you use the API for transcode jobs that use frame rate conversion,
specify the frame rate as a fraction. For example, 24000 / 1001 =
23.976 fps. Use FramerateNumerator to specify the numerator of this
fraction. In this example, use 24000 for the value of
FramerateNumerator. When you use the console for transcode jobs that
use frame rate conversion, provide the value as a decimal number for
Framerate. In this example, specify 23.976.


=head2 GopSize => Num

GOP Length (keyframe interval) in frames. Must be greater than zero.


=head2 HrdBufferSize => Int

Optional. Size of buffer (HRD buffer model) in bits. For example, enter
five megabits as 5000000.


=head2 MaxBitrate => Int

Ignore this setting unless you set qualityTuningLevel to MULTI_PASS.
Optional. Specify the maximum bitrate in bits/second. For example,
enter five megabits per second as 5000000. The default behavior uses
twice the target bitrate as the maximum bitrate.


=head2 ParControl => Str

Optional. Specify how the service determines the pixel aspect ratio
(PAR) for this output. The default behavior, Follow source
(INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your
output. To specify a different PAR in the console, choose any value
other than Follow source. To specify a different PAR by editing the
JSON job specification, choose SPECIFIED. When you choose SPECIFIED for
this setting, you must also specify values for the parNumerator and
parDenominator settings.


=head2 ParDenominator => Int

Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On
the console, this corresponds to any value other than Follow source.
When you specify an output pixel aspect ratio (PAR) that is different
from your input video PAR, provide your output PAR as a ratio. For
example, for D1/DV NTSC widescreen, you would specify the ratio 40:33.
In this example, the value for parDenominator is 33.


=head2 ParNumerator => Int

Required when you set Pixel aspect ratio (parControl) to SPECIFIED. On
the console, this corresponds to any value other than Follow source.
When you specify an output pixel aspect ratio (PAR) that is different
from your input video PAR, provide your output PAR as a ratio. For
example, for D1/DV NTSC widescreen, you would specify the ratio 40:33.
In this example, the value for parNumerator is 40.


=head2 QualityTuningLevel => Str

Optional. Use Quality tuning level (qualityTuningLevel) to choose how
you want to trade off encoding speed for output video quality. The
default behavior is faster, lower quality, multi-pass encoding.


=head2 RateControlMode => Str

With the VP8 codec, you can use only the variable bitrate (VBR) rate
control mode.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaConvert>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

