#ABSTRACT: Subroutines for FR24-Bot
use v5.12;
use warnings;
package FR24::Bot;

our $VERSION = "0.0.1";
use JSON::PP;
use Exporter qw(import);
use HTTP::Tiny;
use File::Which;
use FR24::Utils;
use Carp qw(confess);

my $UPDATE_MS = 10 * 1000;
# Export version
our @EXPORT = qw($VERSION);
our @EXPORT_OK = qw(loadconfig saveconfig url_exists authorized parse_flights systeminfo);
 

sub new {
    my $class = shift @_;

    my $name = undef;
    my $config = undef;
    # Descriptive instantiation with parameters -param => value
    if (substr($_[0], 0, 1) eq '-') {
        my %data = @_;
        # Try parsing
        for my $i (keys %data) {
            if ($i =~ /^-conf/i) {
                $config = $data{$i};
                if (ref($config) ne "HASH") { 
                    $config = FR24::Utils::loadconfig($config);
                }
            } elsif ($i =~ /^-(name|id)/i) {
                $name = $data{$i};
            } else {
                confess "ERROR FR24::Bot: Unknown parameter $i\n";
            }
        }
    } 
  
   
 
 
    my $self = bless {}, $class;
     
    if (not defined $config->{telegram}->{apikey}) {
        confess "ERROR FR24::Bot: No config provided or no apikey found\n";
    }
    $self->{apikey} = $config->{telegram}->{apikey};
    $self->{name} = $name;
    $self->{config} = $config;
    $self->{ip} = $config->{server}->{ip};
    $self->{port} = $config->{server}->{port};
    $self->{localip} = undef;
    $self->{total} = 0;
    $self->{flights} = {};
    $self->{flights_url} = "http://" . $self->{ip} . ":" . $self->{port} . "/flights.json";
    $self->{users} = {};
    $self->{last_updated} = 0;
    $self->update();
    return $self;
  
}

sub _timestamp_milliseconds {
    return int(time * 1000);
}
sub update {
    my $self = shift;
    my $timestamp = _timestamp_milliseconds();
    if ($timestamp - $self->{last_updated} < $UPDATE_MS) {
        # Update only once per second
        return;
    }
    my $url = $self->{flights_url} . "?time=" . _timestamp_milliseconds();
    confess "No URL specified for update\n" unless defined $url;

    my $content = _curl($url);
    my $data = FR24::Utils::parse_flights($content, 0);
    # Parse the content here
    # Example: extracting flight information
    #my @flights = extract_flights($content);

    # Update the object properties
    $self->{flights} = $data->{data};
    $self->{total} = $data->{total};

    # Other update logic here
    # ...

    return;
}



# Write a $self->update() method to update the object


sub _curl {
    my $url = shift;
    my $response = "";
    eval {
        my $http = HTTP::Tiny->new();
        my $response = $http->get($url);

        if ($response->{success}) {
            return $response->{content};
        } else {
            return "Failed to retrieve URL: $response->{status} $response->{reason}\n";
        }
    };
}

__END__

=pod

=encoding UTF-8

=head1 NAME

FR24::Bot - Subroutines for FR24-Bot

=head1 VERSION

version 0.0.1

=head1 AUTHOR

Andrea Telatin <proch@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2023 by Andrea Telatin.

This is free software, licensed under:

  The MIT (X11) License

=cut
