use strict;
use warnings;

use Module::Build;

my $builder = Module::Build->new(
    module_name        => 'Task::Sites::ShlomiFish',
    dist_author        => 'Shlomi Fish <shlomif@iglu.org.il>',
    dist_version_from  => 'lib/Task/Sites/ShlomiFish.pm',
    configure_requires => {
        'Module::Build' => '0.36',
    },
    requires => {
        'App::XML::DocBook::Builder'                             => 0,
        'CGI'                                                    => 0,
        'CGI::Minimal'                                           => 0,
        'Carp'                                                   => 0,
        'Carp::Always'                                           => 0,
        'Class::Accessor'                                        => 0,
        'Config::IniFiles'                                       => 0,
        'Cwd'                                                    => 0,
        'DBD::SQLite'                                            => 0,
        'DBI'                                                    => 0,
        'DateTime'                                               => 0,
        'DateTime::Format::Strptime'                             => 0,
        'Encode'                                                 => 0,
        'Exporter'                                               => 0,
        'Fcntl'                                                  => 0,
        'File::Basename'                                         => 0,
        'File::Copy'                                             => 0,
        'File::Find'                                             => 0,
        'File::Find::Object'                                     => 0,
        'File::Find::Object::Rule'                               => 0,
        'File::Path'                                             => 0,
        'File::Spec'                                             => 0,
        'File::Spec::Functions'                                  => 0,
        'File::Which'                                            => 0,
        'Games::Solitaire::Verify::Base'                         => 0,
        'HTML::Acronyms'                                         => 0,
        'HTML::Links::Localize'                                  => 0,
        'HTML::Selector::XPath'                                  => 0,
        'HTML::T5'                                               => 0,
        'HTML::TextToHTML'                                       => 0,
        'HTML::TokeParser::Simple'                               => 0,
        'HTML::TreeBuilder::LibXML'                              => 0,
        'HTML::Widgets::NavMenu::ToJSON'                         => 0,
        'HTML::Widgets::NavMenu::ToJSON::Data_Persistence::YAML' => 0,
        'IO::All'                                                => 0,
        'Imager'                                                 => 0,
        'JSON'                                                   => 0,
        'MIME::Types'                                            => 0,
        'Moose'                                                  => 0,
        'Parallel::ForkManager'                                  => 0,
        'Parallel::Map::Segmented'                               => 0,
        'Proc::ProcessTable'                                     => 0,
        'QuadPres'                                               => 0,
        'Set::CSS'                                               => 0,
        'SVG'                                                    => 0,
        'Spork::Shlomify'                                        => '0.0200',
        'String::ShellQuote'                                     => 0,
        'Task::Latemp'                                           => 0,
        'Template::Preprocessor::TTML'                           => 0,
        'Test::Count'                                            => 0,
        'Test::Count::Filter'                                    => 0,
        'Test::HTML::Tidy::Recursive'                            => 0,
        'Test::More'                                             => 0,
        'Test::Perl::Critic'                                     => 0,
        'Test::TrailingSpace'                                    => 0,
        'Text::Hunspell'                                         => 0,
        'Text::VimColor'                                         => 0,
        'URI::Find'                                              => 0,
        'XML::Amazon'                                            => 0,
        'XML::Feed'                                              => 0,
        'XML::Grammar::Fiction'                                  => '0.7.0',
        'XML::Grammar::Fortune'                                  => '0.0107',
        'XML::Grammar::Fortune::Synd::App'                       => 0,
        'XML::Grammar::Fortune::ToText'                          => 0,
        'XML::Grammar::ProductsSyndication'                      => '0.0302',
        'XML::Grammar::Screenplay'                               => '0.7.0',
        'XML::Grammar::Vered'                                    => 0,
        'XML::LibXML::XPathContext'                              => 0,
        'XML::LibXSLT'                                           => 0,
        'XML::Parser'                                            => 0,
        'XML::Writer'                                            => 0,
        'base'                                                   => 0,
        'perl'                                                   => '5.014',
        'strict'                                                 => 0,
        'utf8'                                                   => 0,
        'vars'                                                   => 0,
        'warnings'                                               => 0,
    },
    license        => 'mit',
    add_to_cleanup => ['Task-Sites-ShlomiFish-*'],
    meta_merge     => {
        resources => {
            repository => "https://github.com/thewml/latemp",
            homepage   => "http://web-cpan.shlomifish.org/latemp/",
        },
        keywords => [ "bundle", "shlomif", "site", "task", ],
    },
);

$builder->create_build_script();
