# WebDyne.pm(3pm) #

# NAME #

WebDyne - Dynamic Perl web application framework with template
    compilation and modular design

# SYNOPSIS #

SYNOPSIS

```perl
#  Basic usage
#
use WebDyne qw(html html_sr);

# Render a .psp file to HTML (returns a string)
#
my $html = html('app.psp', { param1 => 'value', param2 => 'value' });

# Render a .psp file to HTML (returns a scalar ref)
#
my $html_ref = html_sr('app.psp', { param1 => 'value', param2 => 'value' });

# With additional options
#
my $html = html('template.psp', { outfile => $fh });
    
```

# DESCRIPTION #

*WebDyne*  is a high-performance, dynamic Perl web application framework. It provides method to integrate Perl code in
 HTMLfiles with dynamic compilation, caching, and a modular architecture.
 WebDyne is designed for flexibility and performance, supporting both CGI
 and persistent environments \(mod_perl, PSGI). The core interface for
 scripts is via the  html  and html_sr  functions, which render \.psp templates to HTML.

WebDyne can be used directly from scripts or as a handler in persistent environments. It supports advanced features such as block
 rendering, custom handlers, caching, and integration with Apache via
 mod_perl and PSGI servers such as Plack and Starman.

Comprehensive documentation around the construction and options within \.psp files, and the general usage of WebDyne within an Apache or
 PSGI server are available in the doc directory of the Perl module or from
 the Github repository.

The simplest representation of a \.psp file that can be rendered is as follows. This example uses several syntactic shortcuts from brevity
 that are not standard HTML, however the output generated by WebDyne is
 alway standards compliant HTML.

```
<start_html>
The current server time is: <? localtime() ?>
```

 If this example is saved as the filename  `app.psp`  it can be rendered to HTML from the command line utility  `wdrender`  as follows:

    $ wdrender app.psp
     
    <!DOCTYPE html><html lang="en"><head><title>Untitled Document</title><meta charset="UTF-8"></head>
    <body><p>The current server time is: Sat Sep 20 17:17:13 2025</p></body></html>

# METHODS #

* **html($filename, \%options, ...)**

    Renders a \.psp file to HTML and returns the result as a string. This is a convenience wrapper around html_sr .

    *Arguments:* 

* *$filename*  \- Path to the \.psp template file.

* *\%options*  \- Hashref or hash of options and parameters to pass to the template.

    *Options:* 

* *handler*  \- Specify a custom handler class \(defaults to WebDyne).

* *outfile*  \- Filehandle to write output to \(optional).

* **html_sr($filename, \%options, ...)**

    Renders a \.psp file to HTML and returns a scalar reference to the result. This is the core rendering function for scripts.

    *Arguments and options are as for
          html.*

* **handler($r, \%params)**

    Main request handler for mod_perl and PSGI environments. Not typically used directly in scripts.

# OPTIONS #

The following options can be passed to  html  and html_sr :  

* **filename**

    application \.psp filename to render \(defaults to first argument).

* **handler**

    Custom handler class to use for rendering.

* **outfile**

    Filehandle to write output to \(optional). 

# SEE ALSO #

[Plack](https://metacpan.org/pod/Plack) [Catalyst](https://metacpan.org/pod/Catalyst) [Dancer2](https://metacpan.org/pod/Dancer2) [Mojolicious](https://metacpan.org/pod/Mojolicious)

# AUTHOR #

Andrew Speer &lt;andrew.speer@isolutions.com.au&gt; and contributors.

# LICENSE #

This library is free software; you can redistribute it and/or modify it under the same terms as Perl itself. See  [http://dev.perl.org/licenses/](http://dev.perl.org/licenses/) .