package Daje::Workflow::GenerateSQL::Script::Sql;
use Mojo::Base 'Daje::Workflow::GenerateSQL::Base::Common', -base, -signatures;
use v5.40;

use Syntax::Keyword::Match qw(match);

has 'tablename' => "";

sub create_sql($self) {

    my $sql = "";
    my $json = $self->json->{sql};
    my $length = scalar @{$json};
    for (my $i = 0; $i < $length; $i++) {
        my $type = @{$json}[$i]->{type};
        my $template = $self->templates->get_data_section($type);
        my $table_name = $self->tablename;
        match ($type : eq) {
            case('insert') {
                my $fields = @{$json}[$i]->{fields};
                my $values =@{$json}[$i]->{values};
                $template =~ s/<<tablename>>/$table_name/ig;
                $template =~ s/<<fields>>/$fields/ig;
                $template =~ s/<<values>>/$values/ig;
            }
            default { $template = "" }
        }
        $sql .= $template;
    }
    $self->set_sql($sql);
    return;
}

1;







#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME

Daje::Workflow::GenerateSQL::Script::Sql


=head1 DESCRIPTION

use v5.30;


=head1 REQUIRES

L<v5.30> 

L<Syntax::Keyword::Match> 

L<Mojo::Base> 


=head1 METHODS

=head2 create_sql($self)

 create_sql($self)();


=cut

