package Daje::Workflow::Savefile::Activity;
use Mojo::Base 'Daje::Workflow::Common::Activity::Base', -base, -signatures;


# NAME
# ====
#
# Daje::Workflow::Savefile::Activity - It's a tool to save an array of files
#
# SYNOPSIS
# ========
#
#     use Daje::Workflow::Savefile::Activity;
#
#      "activity_data": {
#               "file" : {
#                 "target_dir_tag": "sql_target_dir",
#                 "filetype": ".sql",
#                 "file_list_tag": "sql"
#               }
#
#      Mandatory meta data
#
#      - file contains file name or name an path
#
#      - data content to write to disk
#
#
#      Possible meta data
#
#      - path if set to 1 the file tag contains full path
#
#      - new_only if set to 1 dont replace existing file
#
#
# DESCRIPTION
# ===========
#
# Daje::Workflow::Savefile::Activity is a file saver
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

use Mojo::File;

our $VERSION = "1.10";



sub save($self) {

    eval {

        my $files = $self->context->{context}->{$self->activity_data->{file}->{file_list_tag}};
        my $length = scalar @{$files};
        for (my $i = 0; $i < $length; $i++) {
            my $file = "";
            if (exists @{$files}[$i]->{path} and @{$files}[$i]->{path} == 1) {
                $file = @{$files}[$i]->{file};
            } else {
                my $filepath = $self->context->{context}->{$self->activity_data->{file}->{target_dir_tag}};
                $file = $filepath . @{$files}[$i]->{file} . $self->activity_data->{file}->{filetype};
            }
            if (exists @{$files}[$i]->{new_only} and @{$files}[$i]->{new_only} == 1) {
                if (!-e $file) {
                    $self->_save_file($file, @{$files}[$i]->{data});
                }
            } else {
                $self->_save_file($file, @{$files}[$i]->{data});
            }
        }
    };
    $self->error->add_error($@) if defined $@ and length($@) > 0;

    return;
}

sub _save_file($self, $file, $data) {
    open(my $fh, ">", $file);
    print $fh $data;
    close $fh;
}

1;
__END__






#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Workflow::Savefile::Activity - It's a tool to save an array of files



=head1 SYNOPSIS


    use Daje::Workflow::Savefile::Activity;

     "activity_data": {
              "file" : {
                "target_dir_tag": "sql_target_dir",
                "filetype": ".sql",
                "file_list_tag": "sql"
              }

     Mandatory meta data

=over

=item *
file contains file name or name an path

=back

=over

=item *
data content to write to disk

=back


     Possible meta data

=over

=item *
path if set to 1 the file tag contains full path

=back

=over

=item *
new_only if set to 1 dont replace existing file

=back




=head1 DESCRIPTION


Daje::Workflow::Savefile::Activity is a file saver



=head1 REQUIRES

L<Mojo::File> 

L<Mojo::Base> 


=head1 METHODS

=head2 save($self)

 save($self)();


=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

