#!/usr/bin/perl

use warnings;
use strict;
use Test::Inter;
my $ti = new Test::Inter $0;

$ti->use_ok('Math::SigFigs');

my $tests="

####### Invalid

__undef__    =>

+            =>

-            =>

a            =>

a10          =>

####### Zero

0            => 0 1 0 '' 0 ''

000          => 0 1 0 '' 0 ''

0.           => 0 1 0 '' 0 ''

000.         => 0 1 0 '' 0 ''

0.00         => 0.00 2 -2 '' 0 00

+0.00        => 0.00 2 -2 '' 0 00

-0.00        => 0.00 2 -2 '' 0 00

####### Integers

53           => 53 2 0 '' 53 ''

053          => 53 2 0 '' 53 ''

530          => 530 2 1 '' 530 ''

0530         => 530 2 1 '' 530 ''

+53          => 53 2 0 '' 53 ''

+053         => 53 2 0 '' 53 ''

+530         => 530 2 1 '' 530 ''

+0530        => 530 2 1 '' 530 ''

'+ 53'       => 53 2 0 '' 53 ''

'+ 053'      => 53 2 0 '' 53 ''

'+ 530'      => 530 2 1 '' 530 ''

'+ 0530'     => 530 2 1 '' 530 ''

-53          => -53 2 0 - 53 ''

-053         => -53 2 0 - 53 ''

-530         => -530 2 1 - 530 ''

-0530        => -530 2 1 - 530 ''

'- 53'       => -53 2 0 - 53 ''

'- 053'      => -53 2 0 - 53 ''

'- 530'      => -530 2 1 - 530 ''

'- 0530'     => -530 2 1 - 530 ''

####### Pure decimals

0.0023       => 0.0023 2 -4 '' 0 0023

0.00230      => 0.00230 3 -5 '' 0 00230

.0023        => 0.0023 2 -4 '' 0 0023

.00230       => 0.00230 3 -5 '' 0 00230

00.0023      => 0.0023 2 -4 '' 0 0023

00.00230     => 0.00230 3 -5 '' 0 00230

+0.0023      => 0.0023 2 -4 '' 0 0023

+0.00230     => 0.00230 3 -5 '' 0 00230

+.0023       => 0.0023 2 -4 '' 0 0023

+.00230      => 0.00230 3 -5 '' 0 00230

+00.0023     => 0.0023 2 -4 '' 0 0023

+00.00230    => 0.00230 3 -5 '' 0 00230

-0.0023      => -0.0023 2 -4 - 0 0023

-0.00230     => -0.00230 3 -5 - 0 00230

-.0023       => -0.0023 2 -4 - 0 0023

-.00230      => -0.00230 3 -5 - 0 00230

-00.0023     => -0.0023 2 -4 - 0 0023

-00.00230    => -0.00230 3 -5 - 0 00230

####### Reals

12.0023      => 12.0023 6 -4 '' 12 0023

12.00230     => 12.00230 7 -5 '' 12 00230

012.0023     => 12.0023 6 -4 '' 12 0023

012.00230    => 12.00230 7 -5 '' 12 00230

+12.0023     => 12.0023 6 -4 '' 12 0023

+12.00230    => 12.00230 7 -5 '' 12 00230

-12.0023     => -12.0023 6 -4 - 12 0023

-12.00230    => -12.00230 7 -5 - 12 00230

####### Exponentials

5.352e0      => 5.352 4 -3 '' 5 352

5.352e2      => 535.2 4 -1 '' 535 2

5.352e3      => 5352 4 0 '' 5352 ''

5.352e5      => 535200 4 2 '' 535200 ''

5.350e0      => 5.350 4 -3 '' 5 350

5.350e2      => 535.0 4 -1 '' 535 0

5.350e3      => 5350. 4 0 '' 5350 ''

5.350e5      => 535000 4 2 '' 535000 ''

5.352e+2     => 535.2 4 -1 '' 535 2

5.352e+02    => 535.2 4 -1 '' 535 2

0.00535e0    => 0.00535 3 -5 '' 0 00535

0.00535e1    => 0.0535 3 -4 '' 0 0535

0.00535e2    => 0.535 3 -3 '' 0 535

0.00535e3    => 5.35 3 -2 '' 5 35

0.00535e5    => 535 3 0 '' 535 ''

0.00535e6    => 5350 3 1 '' 5350 ''

32e2         => 3200 2 2 '' 3200 ''

123.45e-1    => 12.345 5 -3 '' 12 345

123.45e-2    => 1.2345 5 -4 '' 1 2345

123.45e-3    => 0.12345 5 -5 '' 0 12345

123.45e-4    => 0.012345 5 -6 '' 0 012345

123.45e-01   => 12.345 5 -3 '' 12 345

0.00e0       => 0.00 2 -2 '' 0 00

0.00e1       => 0.0 2 -1 '' 0 0

0.00e2       => 0 2 0 '' 0 ''

0.00e3       => 0 2 1 '' 0 ''

12.          => 12 2 0 '' 12 ''

-12.         => -12 2 0 - 12 ''

";

$ti->tests(func  => \&Math::SigFigs::_Simplify,
           tests => $tests);
$ti->done_testing();
1;

# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 3
# cperl-continued-statement-offset: 2
# cperl-continued-brace-offset: 0
# cperl-brace-offset: 0
# cperl-brace-imaginary-offset: 0
# cperl-label-offset: 0
# End:

