/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.sequencediagram.MessageExo;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class CommunicationExoTile
implements Tile {
    private final LivingSpace livingSpace;
    private final MessageExo message;
    private final Skin skin;
    private final ISkinParam skinParam;
    private final Real alpha;
    private final Real omega;

    public CommunicationExoTile(LivingSpace livingSpace, MessageExo messageExo, Skin skin, ISkinParam iSkinParam, Real real, Real real2) {
        this.livingSpace = livingSpace;
        this.message = messageExo;
        this.skin = skin;
        this.skinParam = iSkinParam;
        this.alpha = real;
        this.omega = real2;
    }

    private Component getComponent(StringBounder stringBounder) {
        ArrowConfiguration arrowConfiguration = this.message.getArrowConfiguration();
        if (this.message.getType().getDirection() == -1) {
            arrowConfiguration = arrowConfiguration.reverse();
        }
        Component component = this.skin.createComponent(ComponentType.ARROW, arrowConfiguration, this.skinParam, this.message.getLabel());
        return component;
    }

    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        double d = this.getPoint1(stringBounder).getCurrentValue();
        double d2 = this.getPoint2(stringBounder).getCurrentValue();
        Area area = new Area(d2 - d, dimension2D.getHeight());
        uGraphic = uGraphic.apply(new UTranslate(d, 0.0));
        component.drawU(uGraphic, area, new SimpleContext2D(false));
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        return dimension2D.getHeight();
    }

    public void addConstraints(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        double d = dimension2D.getWidth();
        Real real = this.getPoint1(stringBounder);
        Real real2 = this.getPoint2(stringBounder);
        if (real.getCurrentValue() < real2.getCurrentValue()) {
            real2.ensureBiggerThan(real.addFixed(d));
        } else {
            real.ensureBiggerThan(real2.addFixed(d));
        }
    }

    private Real getPoint1(StringBounder stringBounder) {
        if (this.message.getType().isRightBorder()) {
            return this.livingSpace.getPosC(stringBounder);
        }
        return this.alpha;
    }

    private Real getPoint2(StringBounder stringBounder) {
        if (this.message.getType().isRightBorder()) {
            return this.omega;
        }
        return this.livingSpace.getPosC(stringBounder);
    }

    public Real getMinX(StringBounder stringBounder) {
        return this.getPoint1(stringBounder);
    }

    public Real getMaxX(StringBounder stringBounder) {
        return this.getPoint2(stringBounder);
    }
}

