/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.util.HashSet;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.ExpressionLocation;
import net.sf.saxon.expr.sort.IntHashSet;
import net.sf.saxon.om.Name10Checker;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.serialize.charcode.XMLCharacterData;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class XML10ContentChecker
extends ProxyReceiver {
    private NameChecker checker = Name10Checker.getInstance();
    private IntHashSet fingerprintCache = new IntHashSet(100);
    private HashSet<NodeName> nameCache = new HashSet(100);

    public XML10ContentChecker(Receiver next) {
        super(next);
    }

    public void startElement(NodeName elemName, SchemaType typeCode, int locationId, int properties) throws XPathException {
        if (elemName.hasFingerprint()) {
            if (!this.fingerprintCache.contains(elemName.getNameCode())) {
                this.checkLocalName(elemName, locationId);
                this.fingerprintCache.add(elemName.getNameCode());
            }
        } else if (!this.nameCache.contains(elemName)) {
            this.checkLocalName(elemName, locationId);
            this.nameCache.add(elemName);
        }
        this.nextReceiver.startElement(elemName, typeCode, locationId, properties);
    }

    private void checkLocalName(NodeName elemName, int locationId) throws XPathException {
        if (!this.checker.isValidNCName(elemName.getLocalPart())) {
            XPathException err = new XPathException("Invalid XML 1.0 element name " + Err.wrap(elemName.getLocalPart(), 1));
            err.setErrorCode("SERE0005");
            err.setLocator(new ExpressionLocation(this.getPipelineConfiguration().getLocationProvider(), locationId));
            throw err;
        }
    }

    public void attribute(NodeName attName, SimpleType typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if (attName.hasFingerprint() && !this.fingerprintCache.contains(attName.getFingerprint())) {
            if (!this.checker.isValidNCName(attName.getLocalPart())) {
                XPathException err = new XPathException("Invalid XML 1.0 attribute name " + Err.wrap(attName.getLocalPart(), 2));
                err.setErrorCode("SERE0005");
                err.setLocator(new ExpressionLocation(this.getPipelineConfiguration().getLocationProvider(), locationId));
                throw err;
            }
            this.fingerprintCache.add(attName.getFingerprint());
        }
        if (!this.nameCache.contains(attName)) {
            if (!this.checker.isValidNCName(attName.getLocalPart())) {
                XPathException err = new XPathException("Invalid XML 1.0 attribute name " + Err.wrap(attName.getLocalPart(), 2));
                err.setErrorCode("SERE0005");
                err.setLocator(new ExpressionLocation(this.getPipelineConfiguration().getLocationProvider(), locationId));
                throw err;
            }
            this.nameCache.add(attName);
        }
        this.checkString(value, locationId);
        this.nextReceiver.attribute(attName, typeCode, value, locationId, properties);
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        this.checkString(chars, locationId);
        this.nextReceiver.characters(chars, locationId, properties);
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        this.checkString(chars, locationId);
        this.nextReceiver.comment(chars, locationId, properties);
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        if (!this.checker.isValidNCName(target)) {
            XPathException err = new XPathException("Invalid XML 1.0 processing instruction name " + Err.wrap(target));
            err.setErrorCode("SERE0005");
            err.setLocator(new ExpressionLocation(this.getPipelineConfiguration().getLocationProvider(), locationId));
            throw err;
        }
        this.checkString(data, locationId);
        this.nextReceiver.processingInstruction(target, data, locationId, properties);
    }

    private void checkString(CharSequence in, long locationId) throws XPathException {
        int len = in.length();
        for (int c = 0; c < len; ++c) {
            int ch32 = in.charAt(c);
            if (UTF16CharacterSet.isHighSurrogate(ch32)) {
                char low = in.charAt(++c);
                ch32 = UTF16CharacterSet.combinePair((char)ch32, low);
            }
            if (XMLCharacterData.isValid10(ch32)) continue;
            XPathException err = new XPathException("The result tree contains a character not allowed by XML 1.0 (hex " + Integer.toHexString(ch32) + ')');
            err.setErrorCode("SERE0006");
            err.setLocator(new ExpressionLocation(this.getPipelineConfiguration().getLocationProvider(), locationId));
            throw err;
        }
    }
}

