package Yukki::Settings::Privileges;
$Yukki::Settings::Privileges::VERSION = '0.991_004'; # TRIAL

$Yukki::Settings::Privileges::VERSION = '0.991004';use v5.24;
use utf8;
use Moo;

use Types::Standard qw( ArrayRef Str );
use Yukki::Types qw( AccessLevel );

use namespace::clean;

# ABSTRACT: settings describing privileges


has anonymous_access_level => (
    is          => 'ro',
    isa         => Yukki::Types::AccessLevel,
    required    => 1,
    default     => 'none',
);


has read_groups => (
    is          => 'ro',
    isa         => Str|ArrayRef[Str],
    required    => 1,
    default     => 'NONE',
);


has write_groups => (
    is          => 'ro',
    isa         => Str|ArrayRef[Str],
    required    => 1,
    default     => 'NONE',
);

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Yukki::Settings::Privileges - settings describing privileges

=head1 VERSION

version 0.991_004

=head1 DESCRIPTION

This just encapsultate privilege requirements to do certain actions.

=head1 ATTRIBUTES

=head2 anonymous_access_level

This should be set to one of the following: read, write, or none. This settings decides how much access an anonymous user has when visiting your wiki.

=head2 read_groups

This may be set to the word "ANY" or the word "NONE" or to an array of group names.

If set to ANY, any logged user may read this repository. If set to NONE, read access is not granted to any logged user (though if C<anonymous_access_level> or C<write_groups> grant a user access, the user will be able to read the repository).

If an array of one or more group names are given, the users with any of those groups will be able to read the repository.

=head2 write_groups

THe possible values that may be set are identicl to C<read_groups>. This setting determines who has permission to edit pages and upload files to the repository.

=head1 AUTHOR

Andrew Sterling Hanenkamp <hanenkamp@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Qubling Software LLC.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
