

%x WIDTH BODY

%{
/*                                                                
**  Copyright (C) 2007,2010  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* rdbpar.l
**/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "pfile.h"
#include "ptemplat.h"
#include "parameter.h"
#include "rdb.h"

#include "mode.h"

#define YY_SKIP_YYWRAP

#define StrCpy(res, str, len)	( strncpy((res=malloc(len + 1)), str, len),\
					res[len] = '\0', res)

/* This array and the field variable to cycle through the  context dependence
** of the current field that is expected.
**/
static int	fields[7];
static int	widths[7];
static int	field = 0;
static Parameter *p;
static ParamList *result;

#define YY_USER_INIT	{ BEGIN(fields[field = 0]);		}
/**
#define YY_USER_ACTION  { printf("field = %d, state = %d\n", field, rdb_start); }
**/

#define P	printf

#undef  YY_INPUT
#define YY_INPUT(buffer, result, max)					\
	{								\
		result = fread(buffer, 1, max, (FILE *) rdb_in);		\
	}

#define NAME	0
#define TYPE	1
#define MODE	2
#define VALUE	3
#define MIN	4
#define MAX	5
#define PROMPT	6

/* default rdbwrap function - always treat EOF as an EOF */
static int rdb_wrap(void ) {
	return 1;
}
%}


%%

name		{	fields[field] = NAME;		}
mode		{	fields[field] = MODE;		}
value		{	fields[field] = VALUE;		}
type		{	fields[field] = TYPE;		}
min		{	fields[field] = MIN;		}
max		{	fields[field] = MAX;		}
prompt		{	fields[field] = PROMPT;		}
\n		{
			if ( fields[NAME] ) {
				field = 0;
				BEGIN(WIDTH);
			}
		}

<WIDTH>-+	{	widths[field] = strlen(rdb_text);	}
<WIDTH>\n	{	field = 0;
			BEGIN(BODY);
		}

<BODY>[^\n\t]+	{	
  switch ( fields[field] ) {
    char *s;
    int  mode;

  case NAME:
    p = ParamName(p, StrCpy(s, rdb_text, rdb_leng)); break;

  case TYPE:
    if ( p )
      if ( !ParamType(p, String2Type(rdb_text))) {
	paramerr(0, "rdb parser", p->pname);
	free(p);
      }
    break;

  case MODE:
    if ( p ) 
      if ( !ParamMode(p, String2Mode(rdb_text, &mode))) {
	paramerr(0, "rdb parser", p->pname);
	free(p);
      }
    break;

  case VALUE:
    if ( p ) p = ParamValue(p, StringType, StrCpy(s, rdb_text, rdb_leng)); break;
  case MIN:
    if ( p ) p = ParamMin(p, StringType, StrCpy(s, rdb_text, rdb_leng)); break;
  case MAX:
    if ( p ) p = ParamMax(p, StringType, StrCpy(s, rdb_text, rdb_leng)); break;
  case PROMPT:
    if ( p ) p = ParamPrompt(p, StrCpy(s, rdb_text, rdb_leng)); break;
			}
		}
<BODY>\n	{	if ( p && (p->pvalue.value==NULL) )
				VNewValue(&p->pvalue, "", StringType);
			if ( p )
			  result = PListAdd(result, p);

			field = 0;
			p = NULL;
		}
<INITIAL,WIDTH,BODY>\t {	field++;		}
<<EOF>>		{ return 1;	}
.		{ return 0; 	}
%%


ParamList *RDBParFile(FILE *f)
{
   static int parser = 0;

	if ( parser ) {
		rdb_restart((FILE *) f);
		BEGIN(0);
	} else {
		rdb_in = (void *) f;
		parser = 1;
	}

	result = NULL;
	if ( !rdb_lex() && result ){
            PFree(result);
	    result = (ParamList *)NULL;
         }

	return result;
}
