# This file was autogenerated.

=head1 NAME

t/unit/Hydrogen/Curry/Bool.t - unit tests for Hydrogen::Curry::Bool

=head1 AUTHOR

Toby Inkster E<lt>tobyink@cpan.orgE<gt>.

=head1 COPYRIGHT AND LICENCE

This software is copyright (c) 2022-2025 by Toby Inkster.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 DISCLAIMER OF WARRANTIES

THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

=cut

use 5.008001;
use strict;
use warnings;
use Test2::V0 -target => "Hydrogen::Curry::Bool";

isa_ok( 'Hydrogen::Curry::Bool', 'Exporter::Tiny' );

my %EXPORTS = map +( $_ => 1 ), @Hydrogen::Curry::Bool::EXPORT_OK;

subtest 'curry_not' => sub {
    ok exists(&Hydrogen::Curry::Bool::curry_not), 'function exists';
    ok $EXPORTS{'curry_not'}, 'function is importable';
    my $exception = dies {
        my $curried = Hydrogen::Curry::Bool::curry_not( !!0 );
        is ref( $curried ), 'CODE', 'function returns a coderef';
    };
    is $exception, undef, 'no exception thrown running curry_not';
};

subtest 'curry_reset' => sub {
    ok exists(&Hydrogen::Curry::Bool::curry_reset), 'function exists';
    ok $EXPORTS{'curry_reset'}, 'function is importable';
    my $exception = dies {
        my $curried = Hydrogen::Curry::Bool::curry_reset( !!0 );
        is ref( $curried ), 'CODE', 'function returns a coderef';
    };
    is $exception, undef, 'no exception thrown running curry_reset';
};

subtest 'curry_set' => sub {
    ok exists(&Hydrogen::Curry::Bool::curry_set), 'function exists';
    ok $EXPORTS{'curry_set'}, 'function is importable';
    my $exception = dies {
        my $curried = Hydrogen::Curry::Bool::curry_set( !!0 );
        is ref( $curried ), 'CODE', 'function returns a coderef';
    };
    is $exception, undef, 'no exception thrown running curry_set';
};

subtest 'curry_toggle' => sub {
    ok exists(&Hydrogen::Curry::Bool::curry_toggle), 'function exists';
    ok $EXPORTS{'curry_toggle'}, 'function is importable';
    my $exception = dies {
        my $curried = Hydrogen::Curry::Bool::curry_toggle( !!0 );
        is ref( $curried ), 'CODE', 'function returns a coderef';
    };
    is $exception, undef, 'no exception thrown running curry_toggle';
};

subtest 'curry_unset' => sub {
    ok exists(&Hydrogen::Curry::Bool::curry_unset), 'function exists';
    ok $EXPORTS{'curry_unset'}, 'function is importable';
    my $exception = dies {
        my $curried = Hydrogen::Curry::Bool::curry_unset( !!0 );
        is ref( $curried ), 'CODE', 'function returns a coderef';
    };
    is $exception, undef, 'no exception thrown running curry_unset';
};

done_testing; # :)
